/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.asistente;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionInformacion;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.SoporteValidacionInformacion;
import java.util.regex.Pattern;

public class Contribuyente
extends ObjetoModelo
implements InformacionValidable {
    private static final long serialVersionUID = 3784812180044561356L;
    public static final String C_RAZON_SOCIAL = "razonSocial";
    private String identificacion;
    private String razonSocial;
    private SoporteValidacionInformacion soporteValidacion = new SoporteValidacionInformacion(){

        protected ResultadoValidacion validarInformacion() {
            ResultadoValidacion resultado = new ResultadoValidacion();
            if (!Pattern.matches("^[A-Z0-9]{1}[A-Z0-9\\s]{4,499}$", Contribuyente.this.razonSocial)) {
                return resultado.fallarValidacion("La raz\u00f3n social no debe contener caracteres especiales con una longitud de entre 5 y 500 caracteres");
            }
            return resultado.pasarValidacion();
        }
    };

    public String getIdentificacion() {
        return this.identificacion;
    }

    public String getRazonSocial() {
        return this.razonSocial;
    }

    public void setIdentificacion(String identificacion) {
        this.identificacion = identificacion;
    }

    public void setRazonSocial(String razonSocial) {
        String oldValue = this.razonSocial;
        this.razonSocial = razonSocial;
        this.firePropertyChange(C_RAZON_SOCIAL, oldValue, this.razonSocial);
    }

    public ResultadoValidacion validar() {
        return this.soporteValidacion.validar();
    }

    public void setListenerValidacion(ListenerValidacionInformacion listenerValidacion) {
        this.soporteValidacion.setListenerValidacion(listenerValidacion);
    }
}

